/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.uicontrols.textfield;

import filenet.vw.toolkit.utils.uicontrols.textfield.VWMaskToken;
import java.util.Vector;

class VWMaskTokenizer {
    protected Vector m_tokens = new Vector();
    protected int m_pos = 0;
    protected String m_include;
    protected String m_exclude;

    public VWMaskTokenizer(String include, String exclude) {
        this.m_include = include;
        this.m_exclude = exclude;
    }

    public void tokenize(String text) {
        int prev = 0;
        this.m_tokens.removeAllElements();
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < text.length(); ++i) {
            if (this.m_include.indexOf(text.charAt(i)) > -1) {
                if (buffer.length() > 0) {
                    this.m_tokens.addElement(new VWMaskToken(prev, buffer.toString()));
                }
                this.m_tokens.addElement(new VWMaskToken(i, "" + text.charAt(i)));
                buffer.setLength(0);
                prev = i + 1;
                continue;
            }
            if (this.m_exclude.indexOf(text.charAt(i)) > -1) {
                if (buffer.length() > 0) {
                    this.m_tokens.addElement(new VWMaskToken(prev, buffer.toString()));
                }
                buffer.setLength(0);
                prev = i + 1;
                continue;
            }
            buffer.append(text.charAt(i));
        }
        if (buffer.length() > 0) {
            this.m_tokens.addElement(new VWMaskToken(prev, buffer.toString()));
        }
    }

    public boolean hasMoreTokens() {
        return this.m_pos < this.m_tokens.size();
    }

    public VWMaskToken nextToken() {
        return (VWMaskToken)this.m_tokens.elementAt(this.m_pos++);
    }

    public void ignoreToken() {
        if (this.m_pos > 0) {
            --this.m_pos;
        }
    }

    public static void main(String[] args) {
        VWMaskTokenizer tokenizer = new VWMaskTokenizer("-,", " \t\n");
        String text = "123-45-6--7,234  2423";
        tokenizer.tokenize(text);
        System.out.println(text);
        while (tokenizer.hasMoreTokens()) {
            System.out.println(tokenizer.nextToken());
        }
    }
}

